/*
  Extension       GuideLines
  Author          Carlo Hogeveen
  Website         eCarlo.nl/tse
  Compatibility   Windows GUI TSE
  Version         v0.0.0.2   25 Oct 2025

  This is a placeholder for a requested macro.
  The request was:
    "Lines (see vscode and many others) that show the structure of if's,
     whiles, for's, etc."
  In other editors these lines are named "indent(ation) guides".
  Alegedly one editor colors indent guides based on indentation depth.
  The VSCode editor emphesizes the guide of the smallest code block that the
  current line is part of.

  TODO
    MUST
    - Implement the basic request.
    SHOULD
    COULD
    - Implement guide lines for a marked block.
    - Implement guide lines for the cursor line.
    - Implement indent-depth-coloring and/or -emphasizing.
    WONT


  HISTORY

  v0.0.0.2   28 Oct 2025
    Renamed the design from "IndentGuides" to "GuideLines" to allow for the
    future possibility that the functionality could be extended to implement
    marked block guide lines and cursor line guide lines.

*/

/*
  T E C H N I C A L   B A C K G R O U N D   I N F O

  DETERMINING INDENT GUIDES

  Rules:
    Indent guides are only drawn at the file's indentation columns,
    and only at zero indentation or one indentation deeper than the
    enclosing indentation.
    No indent guides occur in comments.

  Rough algorithm:
    From the top line of the window upwards
    find the first line with the lowest indentation
    that matches the file's indentations.

    From that line downwards to the last window line:
      If a line is indented one indentation more than the previous line,
      then "draw" a guide line downwards at the indentation of the previous
      line until interrupted by a non-whitespace.
      "draw": Only actually draw the guide line where it overlaps the window.

    To work instantly, the _post_update_all_windows_ hook needs to be used.

*/

