/*
  Extension     HistMerge
  Author        Carlo Hogeveen
  Website       eCarlo.nl/tse
  Compatibility TSE v4 upwards, all variants
  Version       v0.0.0.2   17 Feb 2026 (2)


  THIS IS A DEVELOPMENT VERSION !!!

  It has two major flaws:
  - Histories are merged, but imperfectly.
  - Closing TSE takes 9 seconds longer.
  I need a new plan.



  No longer lose new history list entries.

  This extension makes TSE sessions not overwrite each other's history lists.

  In most TSE prompts cursor-up/down offers a history list to choose from.
  Usually each prompt has its own history list.
  New user input gets added to the prompt's history list.
  When a TSE session closes, it writes its updated history lists to a file for
  use by future TSE sessions.
  Normally when multiple TSE sessions are opened concurrently, the last one
  closed is the last one to overwrite the file, thus overwriting any new
  history entries from the other closed TSE sessions.
  HistMerge instead merges sessions' new history entries when TSE closes.



  HISTORY

  v0.0.0.2   17 Feb 2026 (2)
    Still works imperfectly but now "only" closes TSE 9 seconds slower.
    I need a new plan.

  v0.0.0.1   17 Feb 2026
    Initial development version.
    Works imperfectly and closes TSE 19 seconds slower.
*/


// Constants and semi-constants.
string  MACRO_NAME [MAXSTRINGLEN] = ''
#define CUR_HIST_ID                 6

#ifdef LINUX
  string PATH_SEPARATOR [1] = ':'
#else
  string PATH_SEPARATOR [1] = ';'
#endif

/*
integer t0 = 0
integer t1 = 0
integer t2 = 0
integer t3 = 0
*/

/*
integer proc sav_NumHistoryItems(integer history_num)
  integer result = 0

  if lFind(Chr(history_num), 'g^')
    repeat
      result = result + 1
    until not lFind(Chr(history_num), '^+')
  endif

  return(result)
end sav_NumHistoryItems


string proc sav_GetHistoryStr(integer history_num, integer sav_entry_num)
  integer counter               = 0
  string  result [MAXSTRINGLEN] = ''
  string  search_options    [2] = 'g^'

  while lFind(Chr(history_num), search_options)
    counter = counter + 1
    if counter == sav_entry_num
      result = GetText(2, MAXSTRINGLEN)
      break
    endif
    search_options = '^+'
  endwhile

  return(result)
end sav_GetHistoryStr
*/


proc merge_new_histories()
  integer cur_entry_num                  = 0
  string  cur_history_str [MAXSTRINGLEN] = ''
  integer cur_hist_new_entries_id        = 0
  integer history_num                    = 0
  integer org_id                         = GetBufferId()
  integer sav_entry_num                  = 0
  string  sav_entry_str   [MAXSTRINGLEN] = ''
  string  sav_history_str [MAXSTRINGLEN] = ''
  integer sav_hist_id                    = 0

  // t0 = GetTime()

  cur_hist_new_entries_id = CreateTempBuffer()
  ChangeCurrFilename(MACRO_NAME + ':CurHistNewEntries',
                     _DONT_PROMPT_|_DONT_EXPAND_|_OVERWRITE_)

  sav_hist_id             = CreateTempBuffer()
  ChangeCurrFilename(MACRO_NAME + ':SavedHistoryLists',
                     _DONT_PROMPT_|_DONT_EXPAND_|_OVERWRITE_)

  if LoadBuffer(SearchPath('tsehist.dat',
                           LoadDir() + PATH_SEPARATOR
                           + SplitPath(LoadDir(TRUE), _DRIVE_|_PATH_)),
                -2)

    // t1 = GetTime()

    BegFile()
    //  Ignore the header line.
    KillLine()
    //  In the file the history lists are intermixed, leading to slow access.
    //  Therefore create an indexed memory structure instead.
    do NumLines() times
      history_num   = CurrChar()
      sav_entry_str = GetText(2, MAXSTRINGLEN)
      sav_entry_num = GetBufferInt(Format('NumHistoryItems:', history_num),
                                   sav_hist_id)
                    + 1
      SetBufferStr(Format('Entry:', history_num, ':', sav_entry_num),
                   sav_entry_str,
                   sav_hist_id)
      SetBufferInt(Format('NumHistoryItems:', history_num),
                   sav_entry_num,
                   sav_hist_id)
      Down()
    enddo

    // t2 = GetTime()

    for history_num = 1 to 255
      cur_entry_num = NumHistoryItems(history_num)
      sav_entry_num = GetBufferInt(Format('NumHistoryItems:', history_num),
                                   sav_hist_id)

      //  New history entries were added top-down, at entry 1, shifting the
      //  existing entries down one place.
      //  Therefore determine bottom-up where the current and saved history
      //  lists start to differ.
      cur_history_str = GetHistoryStr(history_num, cur_entry_num)
      sav_history_str = GetBufferStr(Format('Entry:', history_num, ':',
                                            sav_entry_num),
                                     sav_hist_id)

      while cur_entry_num
      and   sav_entry_num
      and   cur_history_str == sav_history_str
        cur_entry_num = cur_entry_num - 1
        sav_entry_num = sav_entry_num - 1
        cur_history_str = GetHistoryStr(history_num, cur_entry_num)
        sav_history_str = GetBufferStr(Format('Entry:', history_num, ':',
                                              sav_entry_num),
                                       sav_hist_id)
      endwhile
      //  If the saved history list has new entries that are not in the current
      //  history list ...
      if sav_entry_num
        //  Add the current history list's new entries to a temporary buffer.
        EmptyBuffer(cur_hist_new_entries_id)
        for cur_entry_num = cur_entry_num downto 1
          cur_history_str = GetHistoryStr(history_num, cur_entry_num)
          AddLine(cur_history_str, cur_hist_new_entries_id)
        endfor
        //  Now bottom-up add the saved history list's new entries to the
        //  current history list, putting them at its top in their original
        //  order.
        for sav_entry_num = sav_entry_num downto 1
          sav_history_str = GetBufferStr(Format('Entry:', history_num, ':',
                                                sav_entry_num),
                                         sav_hist_id)
          AddHistoryStr(sav_history_str, history_num)
        endfor
        //  Now bottom-up re-add the current history list's old "new entries"
        //  to the current history list. This achieves that they get added to
        //  its top again in their original order.
        GotoBufferId(cur_hist_new_entries_id)
        EndFile()
        do NumLines() times
          AddHistoryStr(GetText(1, MAXSTRINGLEN), history_num)
          // d3 = d3 + 1
        enddo
      endif
    endfor
  endif

  //  Now the current history lists contain the merged new history entries,
  //  and we just let TSE itself save its current history lists as usual.

  GotoBufferId(org_id)
  AbandonFile(cur_hist_new_entries_id)
  AbandonFile(sav_hist_id)

  // t3 = GetTime()
  // Warn(MACRO_NAME; 'run-times:'; t1 - t0; t2 - t1; t3 - t2)
end merge_new_histories


proc WhenPurged()
  merge_new_histories()
end WhenPurged


proc WhenLoaded()
  Hook(_ON_ABANDON_EDITOR_, WhenPurged)
end WhenLoaded


proc Main()
  MsgBox(MACRO_NAME,
         'This extension has no configuration options.' + Chr(13)
         + "Simply add its name to TSE's Macro AutoLoad List menu" + Chr(13)
         + 'to make it work in all future TSE sessions.')
end Main


