/*
  Tool            Test_Console_ColorTableValues
  Author          Carlo Hogeveen
  Website         eCarlo.nl/tse
  Compatibility   Recent TSE versions, all variants
  Version         v1   24 Nov 2025


  TRIGGER-WARNING
    This tool uses flashing lights!


  This tool proves that in recent versions of TSE up to at least v4.50.13
  Console TSE's colors are gettable and settable to a BGR color using TSE's
  GetColorTableVlaue() and SetColorTableValue() functions.

  But with this twist:
  In GUI TSE and Linux TSE these functions return and expect an RGB color,
  while in Console TSE they return and expect a BGR color.

  The difference is in the byte order of the red, green, and blue color
  components:
    RGB = R * 256 * 256 + G * 256 + B
    BGR = B * 256 * 256 + G * 256 + R

  For comparison the tool also works in GUI TSE and Linux TSE,
  where it will show red, green, and blue, instead of blue, green, and red.

*/


integer color_component_byte_factor = 65536
integer color_component_byte_value  = 0
integer old_rgb_color               = 0
integer text_background_color_index = 0


proc idle()
  integer rgb_color = 0

  if color_component_byte_value < 256
    rgb_color = color_component_byte_value * color_component_byte_factor
    SetColorTableValue(_BACKGROUND_, text_background_color_index, rgb_color)
    if GetColorTableValue(_BACKGROUND_, text_background_color_index) <> rgb_color
      Alarm()
      SetColorTableValue(_BACKGROUND_, text_background_color_index, old_rgb_color)
      UpdateDisplay(_ALL_WINDOWS_REFRESH_)
      Warn('Test for GetColorTableValue() failed!')
      PurgeMacro(CurrMacroFilename())
    endif
    #ifdef LINUX
      Set(Attr, text_background_color_index * 16)
      ClrScr()
      UpdateDisplay(_ALL_WINDOWS_REFRESH_)
    #else
      if isGUI()
        Set(Attr, text_background_color_index * 16)
        ClrScr()
        UpdateDisplay(_ALL_WINDOWS_REFRESH_)
      else
        UpdateDisplay(_ALL_WINDOWS_REFRESH_)
      endif
    #endif
    color_component_byte_value = color_component_byte_value + 5
  else
    if color_component_byte_factor > 1
      color_component_byte_factor = color_component_byte_factor / 256
      color_component_byte_value  = 0
    else
      Alarm()
      SetColorTableValue(_BACKGROUND_, text_background_color_index, old_rgb_color)
      #ifdef LINUX
        Set(Attr, text_background_color_index * 16)
        ClrScr()
        UpdateDisplay(_ALL_WINDOWS_REFRESH_)
      #else
        if isGUI()
          Set(Attr, text_background_color_index * 16)
          ClrScr()
          UpdateDisplay(_ALL_WINDOWS_REFRESH_)
        else
          UpdateDisplay(_ALL_WINDOWS_REFRESH_)
        endif
      #endif
      PurgeMacro(CurrMacroFilename())
    endif
  endif
end idle


proc WhenPurged()
  SetColorTableValue(_BACKGROUND_, text_background_color_index, old_rgb_color)
end WhenPurged


proc WhenLoaded()
  if YesNo('Are you at risk of seizures triggered by flashing light?') == 2
    text_background_color_index = Query(TextAttr) / 16
    old_rgb_color = GetColorTableValue(_BACKGROUND_, text_background_color_index)
    Hook(_IDLE_             , idle)
    Hook(_ON_ABANDON_EDITOR_, WhenPurged)
  else
    PurgeMacro(CurrMacroFilename())
  endif
end WhenLoaded


